#ifndef CE2_BASE64_H
#define CE2_BASE64_H

/*
 * All the includes that are needed for code using this module to
 * compile correctly should be #included here.
 */
#include "CE2_public.h"

#ifdef __cplusplus
extern "C"
{
#endif

/*
 *  Object %CE2_Base64.h    : %
 *  State           :  %state%
 *  Creation date   :  Tue Jun 24 12:00:00 2008
 *  Last modified   :  %modify_time%
 */
/** @file
 *  \brief This file contains all of the enums and definitions that are used for the 
 *         CE2 Base64 APIs, as well as the APIs themselves
 *
 *  \version CE2_Base64.h#1:incl:1
 *  \author  Aliaksandr Masiuk
 *  \remarks Copyright (C) 2005 by Discretix Technologies Ltd.
 *           All Rights reserved
 */

/************************ Defines *****************************/
/************************ Enums *******************************/
/************************ Typedefs ****************************/
/************************ Structs *****************************/
/************************ Public Variables ********************/
/************************ Public Functions ********************/

/**
****************************************************************
* Function Name: 
*  CE2_Base64_Encode
*
* Inputs:
* @param inputBuffer [in] - A pointer to the buffer that stores the data to be encoded;
* @param inputBufferSizeInBytes[in] - The size of the input buffer in bytes;
* @param outputBuffer [in/out] - A pointer to the target buffer where
*                                the Base64 encoded result will be stored;
*                                If outputBuffer == NULL than outputBufferSizeInBytes
*                                will contain needed output buffer size;
* @param outputBufferSizeInBytes_ptr[in/out] - The size of the output buffer
*                                              in bytes; Will contain
*                                              actual output buffer size;
*
* Outputs: @returns \b
*  CE2Error_t  
*  - CE2_OK - On success
*  - Otherwise - error code:
*   - CE2_BASE64_INPUT_BUFFER_INVALID_PTR_ERROR
*   - CE2_BASE64_OUTPUT_BUFFER_INVALID_PTR_ERROR
*   - CE2_BASE64_OUTPUT_BUFFER_SIZE_TOO_SMALL_ERROR
*   - CE2_LLF_BASE64_MODULE_ERROR_BASE
*
* \brief \b
* Description:
*   The function perform Base64 encode operation.
*
* \b
* Algorithm:
*  -# Verify input parameters for validity;
*  -# Call low level function LLF_Base64_Encode
*    to perform Base64 encoding of inputted data with using LibTomCrypt.
***************************************************************/
CE2CIMPORT_C CE2Error_t CE2_Base64_Encode(const DxUint8_t *inputBuffer,
                                          DxUint32_t      inputBufferSizeInBytes,
                                          DxUint8_t       *outputBuffer,
                                          DxUint32_t      *outputBufferSizeInBytes_ptr);

/**
****************************************************************
* Function Name: 
*  CE2_Base64_Decode
*
* Inputs:
* @param inputBuffer [in] - A pointer to the buffer that stores the data to be decoded;
* @param inputBufferSizeInBytes[in] - The size of the input buffer in bytes;
* @param outputBuffer [in/out] - A pointer to the target buffer where
*                                the Base64 decoded result will be stored;
*                                If outputBuffer == NULL than outputBufferSizeInBytes
*                                will contain needed output buffer size;
* @param outputBufferSizeInBytes_ptr[in/out] - The size of the output buffer
*                                              in bytes; Will contain
*                                              actual output buffer size;
*
* Outputs: @returns \b
*  CE2Error_t  
*  - CE2_OK - On success
*  - Otherwise - error code:
*   - CE2_BASE64_INPUT_BUFFER_INVALID_PTR_ERROR
*   - CE2_BASE64_OUTPUT_BUFFER_INVALID_PTR_ERROR
*   - CE2_BASE64_OUTPUT_BUFFER_SIZE_TOO_SMALL_ERROR
*   - CE2_LLF_BASE64_MODULE_ERROR_BASE
*
* \brief \b
* Description:
*   The function perform Base64 decode operation.
*
* \b
* Algorithm:
*  -# Verify input parameters for validity;
*  -# Call low level function LLF_Base64_Decode
*    to perform Base64 decoding of inputted data with using LibTomCrypt.
***************************************************************/
CE2CIMPORT_C CE2Error_t CE2_Base64_Decode(const DxUint8_t *inputBuffer,
                                          DxUint32_t      inputBufferSizeInBytes,
                                          DxUint8_t       *outputBuffer,
                                          DxUint32_t      *outputBufferSizeInBytes_ptr);

#ifdef __cplusplus
}
#endif

#endif
